import edu.rit.vector.*;
import java.util.ArrayList;

public class Particle {
	private static ArrayList<Particle> g; // global particle list
	private ArrayList<Particle> l; // local particle list
	
	private double x2, y2, gravmag = 1000;
	private ArrayList<Double> x, y;
	private boolean updatedCoordinates = false;
	private static double speed = 3, maxdist = 200;//125;
	public static double rev = 1;
	
	private static Vector2D grav;
	private Vector2D v;
	
	// Constructor
	public Particle(double a, double b) {
		x = new ArrayList<Double>();
		x.add(new Double(a));
		y = new ArrayList<Double>();
		y.add(new Double(b));
		x2 = a;
		y2 = b;
		v = new Vector2D();
		if (grav == null || g == null) {
			grav = new Vector2D(0, gravmag);
			//g = new ArrayList<Particle>();
		}
		l = new ArrayList<Particle>();
		//g.add(this);
	}
	
	// getAll
	//public ArrayList<Particle> getAll() {
	//	return (ArrayList<Particle>) g.clone();
	//}
	
	// step
	public void step(ArrayList<Particle> pg) {
		populateLocalGroup(pg);
		calcVelocity();
		Vector2D w = new Vector2D(v);
		w.mul(speed / w.mag()); // don't know my math
		w.mul(rev);
		x2 += w.x;
		y2 += w.y;
		updatedCoordinates = false;
	}
	
	// swapNewCoordinates
	private void updateNewCoordinates() {
		nextX(x2);
		nextY(y2);
		updatedCoordinates = true;
	}
	
	// populateLocalGroup
	private void populateLocalGroup(ArrayList<Particle> pg) {
		l.clear();
		for (int i = 0; i < pg.size(); i++) {
			Particle pgi = pg.get(i);
			double d = (new Vector2D(x.get(x.size()-1) - pgi.getX(), y.get(y.size()-1) - pgi.getY())).mag();
			if (d < maxdist && !pgi.equals(this)) {
				l.add(pgi);
			}
		}
	}
	
	// calcVelocity
	private void calcVelocity() {
		for (int i = 0; i < l.size(); i++) {
			Particle li = l.get(i);
			Vector2D w = new Vector2D(x.get(x.size()-1) - li.getX(), y.get(y.size()-1) - li.getY());
			//double d = maxdist - w.mag(); // ? closer nodes will exert a stronger force on other nodes / linearly...
			double d = w.mag();
			w.mul(d / maxdist); // rewrite the vector before we add it
			v.add(w);
		}
		v.add(grav);
	}
	
	// removeFromLocalGroup
	private boolean removeFromLocalGroup(Particle p) {
		return l.remove(p);
	}
	
	protected void finalize() throws Throwable {
		//g.remove(this);
		//for (int i = 0; i < g.size(); i++) {
		//	g.get(i).removeFromLocalGroup(this);
		//}
		super.finalize();
	}
	
	protected void destroy() throws Throwable{
		this.finalize();
	}
	
	public double getX() {
		if (!updatedCoordinates) {
			updateNewCoordinates();
		}
		return x.get(x.size()-1);
	}
	public double getX(int t) {
		//if (!updatedCoordinates) {
		//	updateNewCoordinates();
		//}
		return x.get(t);
	}
	public double getY() {
		if (!updatedCoordinates) {
			updateNewCoordinates();
		}
		return y.get(y.size()-1);
	}
	public double getY(int t) {
		//if (!updatedCoordinates) {
		//	updateNewCoordinates();
		//}
		return y.get(t);
	}
	
	public void nextX(double d) {
		x.add(new Double(d));
	}
	public void nextY(double d) {
		y.add(new Double(d));
	}
	
	public int getT() {
		return x.size();
	}
	
	// TODO: format? 
	public String toString() {
		return "[" + x + ", " + y + "]";
	}
}
