import edu.rit.vector.*;
import java.util.ArrayList;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.RenderingHints;
import java.awt.BasicStroke;
import javax.imageio.*;
import java.io.*;
import com.jhlabs.image.*;

public class Tester {
	public static File file;
	public static int video_width = 1920, video_height = 1080, frames = 120, particles = 400;
	public static double hFactor = 0.125, sFactor = 1, render_ratio = 1;
	public static BufferedImage buffer = null;
	public static Graphics2D gc = null;
	public static HSBAdjustFilter hsb = null;
	
	public static Graphics2D drawFrame(Graphics2D gc2d, Frame frame, int i, double ratio, float r, float g, float b, int di) {
		gc2d.setColor(Color.getHSBColor(r, g, b));
		ArrayList<Particle> pg = frame.particleGroups.get(i);
		for (int h = 0; h < pg.size(); h++) {
			Particle p = pg.get(h);
			
			double x = p.getX(), y = p.getY();
			int width = 10, height = 10;
			
			//gc2d.fillArc((int) (video_width - x) % video_width, (int) (video_height - y) % video_height, width, height, (10 * i) % 360, (180 + (10 * i)) % 360);
			gc2d.fillOval((int)x, (int)y, di, di);
		}
		return gc2d;
	}
	
	public static Graphics2D drawFrameTime(int t, Graphics2D gc2d, Frame frame, int i, double ratio, float r, float g, float b, int di) {
		gc2d.setColor(Color.getHSBColor(r, g, b));
		ArrayList<Particle> pg = frame.particleGroups.get(i);
		for (int h = 0; h < pg.size(); h++) {
			Particle p = pg.get(h);
			
			double x = p.getX(t), y = p.getY(t);
			int width = 10, height = 10;
			
			//gc2d.fillArc((int) (video_width - x) % video_width, (int) (video_height - y) % video_height, width, height, (10 * i) % 360, (180 + (10 * i)) % 360);
			gc2d.fillOval((int)x, (int)y, di, di);
		}
		return gc2d;
	}
	
 	public static ArrayList<Particle> populateParticles(int num, int x, int y, int w, int h) {
 		ArrayList<Particle> pg = new ArrayList<Particle>();
		Particle a = new Particle((Math.random() * (w - x)) + x, (Math.random() * (h - y)) + y);
		pg.add(a);
		for (int i = 0; i < num - 1; i++) {
			a = new Particle((Math.random() * (w - x)) + x, (Math.random() * (h - y)) + y);
			pg.add(a);
		}
		return pg;
		//return a;
	}
 	
 	public static ArrayList<Particle> populateParticlesFromImage(String img) {
 		ArrayList<Particle> pg = new ArrayList<Particle>();
 		BufferedImage bimg;
 		try {
 			bimg = ImageIO.read(new File(img));
 			int bw = bimg.getWidth(), bh = bimg.getHeight();
 			for (int h = 0; h < bh; h+=4) {
 				for (int w = 0; w < bw; w+=4) {
 					Color c = new Color(bimg.getRGB(w, h));
 					if (c.getRed() == 0 && c.getBlue() == 0 && c.getGreen() == 0) {
 						Particle p = new Particle(w, h);
 						pg.add(p);
 					}
 				}
 			}
 		} catch (IOException ioe) {
 			// TODO: catch error?
 		}
 		return pg;
 	}
	
	public static void setGraphics(int w, int h) {
		if (buffer == null) {
			GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
			GraphicsConfiguration gconf = ge.getDefaultScreenDevice().getDefaultConfiguration();
		
			buffer = gconf.createCompatibleImage(w, h);
			gc = buffer.createGraphics();
		}
		
		gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		gc.setStroke(new BasicStroke(10));
		
		if (hsb == null) {
			hsb = new HSBAdjustFilter();
			hsb.setHFactor((float) hFactor);
			hsb.setSFactor((float) sFactor);
		}
	}
	
	public static void writeFile(String prefix, int i, BufferedImage buffer) {
		try {
			file = new File(prefix + i + ".png");
			ImageIO.write(buffer, "PNG", file);
		} catch (IOException ioe) {
			// TODO: catch error?
		}
	}
	
	@SuppressWarnings("restriction")
	public static void main(String[] args) {
		setGraphics(video_width, video_height);
		
		Frame f = new Frame();
		//f.addGroup(populateParticles(particles, 0, 0, video_width, video_height));
		//f.addGroup(populateParticlesFromImage("_aspartame_mask.png"));
		f.addGroup(populateParticlesFromImage("_mark_mask.png"));
		//f.addGroup(populateParticles(particles, 0, (int) (video_height), video_width, video_height));
		float hf = 0;
		for (int i = 0; i < frames; i++) {
			//gc.setColor(Color.getHSBColor(0, 0, 0));
			//gc.fillRect(0, 0, video_width, video_height);
			
			//drawFrame(gc, f, 0, 1, (float) (Math.sin((double)i))*360, (float) Math.sin((double)i), (float) 1, 5);
			//drawFrame(gc, f, 0, 1, (float) 0, (float) 0, (float) 1, 7);
			drawFrame(gc, f, 0, 1, (float) 0, (float) 0, (float) ((float)1-((float)(i%2)/(float)2)), 10);
			//drawFrame(gc, f, 0, 1, (float) Math.sin(hf+=0.1), (float) 0.5, (float) 1, (int) ((Math.sin((double)i)*10)+10));
			//drawFrame(gc, f, 0, 1, (float) Math.log10(i - (i % 2)), (float) Math.sin((double)i), (float) 1, 10);
			//drawFrame(gc, f, 0, 1, (float) Math.sin((Math.log10((double)i))*(1 + (i % 2))), (float) Math.tan((double)i), (float) 1, 10);
			//drawFrame(gc, f, 0, 1, (float) Math.sin((i+1)/(i%3+1)), (float) 1, (float) 1, 10);
			writeFile("mark_img", i, buffer);
			f.stepAll(0);
			//f.stepAll(1);
			// hue shift
			//buffer = hsb.filter(buffer, null);
			//gc = buffer.createGraphics();
			//setGraphics(video_width, video_height);
		}
		
		/*int h = frames-1;
		for (int i = frames; i < frames*2; i++) {
			drawFrameTime(h, gc, f, 0, 1, (float) (Math.sin((double)i))*360, (float) Math.sin((double)i), (float) 1, 20);
			//drawFrameTime(h, gc, f, 0, 1, (float) Math.sin(hf+=0.1), (float) 0.5, (float) 1, (int) ((Math.sin((double)i)*10)+10));
			//drawFrameTime(h, gc, f, 0, 1, (float) Math.sin((Math.log10((double)i))*(1 + (i % 2))), (float) Math.tan((double)i), (float) 1, 10);
			//drawFrameTime(h, gc, f, 0, 1, (float) ( i - ((i % 2)* 0.9 * i) ), (float) 1, (float) ((double)i), 10);
			//drawFrameTime(h, gc, f, 0, 1, (float) Math.sin((i+1)/(i%3+1)), (float) 1, (float) 1, 10);
			writeFile("acek_img", i, buffer);
			h--;
		}*/
		
		/*f.addGroup(populateParticles(particles, video_width/4, video_height/4, video_width/2, video_height/2));
		
		for (int i = frames*3; i < frames*3+frames*3; i++) {
			//drawFrame(gc, f, 1, 1, (float) (1 - (i % 2)), (float) Math.sin((double)i), (float) 0.5, 30);
			drawFrame(gc, f, 1, 1, (float) (1 - (i % 2)), (float) Math.sin((double)i), (float) Math.cos((double)i), 30);
			writeFile("test_img", i, buffer);
			f.stepAll(1);
			//f.stepAll(1);
			// hue shift
			//buffer = hsb.filter(buffer, null);
			//gc = buffer.createGraphics();
			//setGraphics(video_width, video_height);
		}*/
		
		System.out.println("Completed.");
	}
}
