// color_util.h
void Sound_to_HSL(float frequency, float amplitude, float scale, float low, float *H, float *S, float *L) {
	*H = (frequency - low) / scale;
	*S = 1;
	*L = amplitude;
}

float Hue_to_RGB(float v1, float v2, float vH) {
	if (vH < 0) {
		vH += 1;
	}
	if (vH > 1) {
		vH -= 1;
	}
	if ((6.0 * vH) < 1) {
		return(v1 + (v2 - v1) * 6.0 * vH);
	}
	if ((2.0 * vH) < 1) {
		return(v2);
	}
	if ((3.0 * vH) < 2) {
		return(v1 + (v2 - v1) * ((2.0/3.0) - vH) * 6.0);
	}
	return(v1);
}

void RGB_to_HSL(gdImagePtr image, int p, float *H, float *S, float *L) {
	// easyRGB.com
	float var_R, var_G, var_B, var_Max, var_Min, del_Max, del_R, del_G, del_B;
	var_R = (((float)gdImageRed(image, p)) / ((float)255)); //Where RGB values = 0 ÷ 255
	var_G = (((float)gdImageGreen(image, p)) / ((float)255));
	var_B = (((float)gdImageBlue(image, p)) / ((float)255));

	var_Min = min(var_R, var_G, var_B); //Min. value of RGB
	var_Max = max(var_R, var_G, var_B); //Max. value of RGB
	del_Max = var_Max - var_Min; //Delta RGB value

	*L = (var_Max + var_Min) / ((float)2);

	if (del_Max == ((float)0)) { //This is a gray, no chroma...
		*H = ((float)0); //HSL results = 0 ÷ 1
		*S = ((float)0);
	} else { //Chromatic data...
		if (*L < ((float)0.5)) {
			*S = del_Max / (var_Max + var_Min);
		}
		else {
			*S = del_Max / (((float)2) - var_Max - var_Min);
		}

		del_R = (((var_Max - var_R) / ((float)6)) + (del_Max / ((float)2))) / del_Max;
		del_G = (((var_Max - var_G) / ((float)6)) + (del_Max / ((float)2))) / del_Max;
		del_B = (((var_Max - var_B) / ((float)6)) + (del_Max / ((float)2))) / del_Max;

		if (var_R == var_Max) {
			*H = del_B - del_G;
		}
		else if (var_G == var_Max) {
			*H = (((float)1) / ((float)3)) + del_R - del_B;
		}
		else if (var_B == var_Max) {
			*H = (((float)2) / ((float)3)) + del_G - del_R;
		}

		if (*H < ((float)0)) {
			*H += ((float)1);
		}
		if (*H > ((float)1)) {
			*H -= ((float)1);
		}
	}
}

void HSL_to_RGB(float H, float S, float L, float *R, float *G, float *B) {
	// easyRGB.com
	float var_1, var_2;
	if (S == 0) { 		//HSL values = 0 ÷ 1
		*R = L * 255;	//RGB results = 0 ÷ 255
		*G = L * 255;
		*B = L * 255;
	}
	else
	{
		if ( L < 0.5 ) {
			var_2 = L * (1 + S);
		} else {
			var_2 = (L + S) - (S * L);
		}
		var_1 = 2 * L - var_2;

		*R = 255 * Hue_to_RGB(var_1, var_2, H + (1.0/3.0));
		*G = 255 * Hue_to_RGB(var_1, var_2, H);
		*B = 255 * Hue_to_RGB(var_1, var_2, H - (1.0/3.0));
	}
}
