// sonify_cleanup.c
#include <math.h>
#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>

#include <jack/jack.h>
#include <gd.h>
#include <aubio/aubio.h>

#include "math_util.h"
#include "color_util.h"

//#include <gnome.h>

//#include "interface.h"
//#include "support.h"

//pthread_t thread;
const double PI = 3.14;

// Jack
typedef jack_default_audio_sample_t sample_t;
jack_port_t *output_port;
jack_port_t *input_port;

char *global_file_name;
int global_image_format;
FILE *global_image_file;

// Waveform Synthesis
jack_nframes_t sample_rate;

sample_t *cycle;
sample_t *temp_cycle;

jack_nframes_t samples_per_cycle;
jack_nframes_t temp_samples_per_cycle;

enum TYPE { Sine = 0, Square, Triangle, Sawtooth };
enum TYPE waveform_type = Sine; // *

float tone = 101;
double amplitude = 1;

float *image_tones;
float *image_tones_amp;

int image_tones_size;
int image_tones_index = 0;
long offset = 0;
float ms_time = 0; // *
int pitch_scale = 5000; // *
int lower_bounds = 100; // *
int framecount = 0;
float hopsize = 0;
float bufsize = 0;
float max_amp = 0;
int X = 0;
int Y = 0;

gdImagePtr source_image, dest_image;

// aubio pitch detection stuff
aubio_pitchdetection_t *aubio = NULL;
smpl_t aubio_pitch = 0;
fvec_t *aubio_fvec = NULL;

void *thread_save();

void init_aubio() {
	hopsize = sample_rate * 0.001 * ms_time;
	bufsize = sizeof(sample_t) * hopsize;
	aubio = new_aubio_pitchdetection(bufsize, hopsize, 1, sample_rate, aubio_pitch_fcomb, aubio_pitchm_freq);
	aubio_fvec = new_fvec(hopsize, 1);
}

void generate_tone_array(gdImagePtr image) {
	int width, height, x, y, p, c = 0;
	width = gdImageSX(image);
	height = gdImageSY(image);
	image_tones_size = width * height;
	image_tones = (float *) malloc(width * height * sizeof(float));
	image_tones_amp = (float *) malloc(width * height * sizeof(float));
	if (image_tones == NULL || image_tones_amp == NULL) {
		fprintf(stderr,"memory allocation failed\n");
		exit(3);
	}
	for (y = 0; y < height; y++) {
		for (x = 0; x < width; x++) {
			p = gdImageGetPixel(image, x, y);
			float H, S, L;
			RGB_to_HSL(image, p, &H, &S, &L);
			image_tones[c] = H * pitch_scale + lower_bounds; // Hue = Frequency
			image_tones_amp[c] = L; // Luminosity = Amplitude
			c++;
		}
	}
}

void write_to_image(gdImagePtr image, float R, float G, float B) {
	int width, height;
	width = gdImageSX(image);
	height = gdImageSY(image);
	if (X == width) {
		X = 0;
		Y++;
	}
	if (Y == height) {
		Y = 0;
	}
	int color = gdImageColorAllocate(image, R, G, B);
	gdImageSetPixel(image, X, Y, color);
	X++;
}

void build_tone(float t, float a, enum TYPE type) {
	temp_samples_per_cycle = (sample_rate / t);
	sample_t scale = 2 * PI / temp_samples_per_cycle;
	temp_cycle = (sample_t *) malloc(temp_samples_per_cycle * sizeof(sample_t));
	
	if (temp_cycle == NULL) {
		fprintf(stderr,"memory allocation failed\n");
		exit(3);
	}
	
	int i = 0;
	for (i = 0; i < temp_samples_per_cycle; i++) {
		switch(type) {
			case Sine:
				temp_cycle[i] = a * sin(i * scale);
				break;
			case Square:
				temp_cycle[i] = a * sgn(sin(i * scale));
				break;
			case Triangle:
				temp_cycle[i] = a * (asin(sin(i * scale)) / (PI / 2));
				break;
			case Sawtooth:
				temp_cycle[i] = a * (2 * ((((float) i) / temp_samples_per_cycle) - floor(((float) i) / temp_samples_per_cycle)) - 1);
				break;
		}
	}
	swap_cycle();
}

void swap_cycle() {
	if (cycle != NULL) {
		sample_t *trash = cycle;
		cycle = temp_cycle;
		free(trash);
	} else {
		cycle = temp_cycle;
	}
	temp_cycle = NULL;
	samples_per_cycle = temp_samples_per_cycle;
	offset = 0;
}

int process(jack_nframes_t nframes, void *arg) {
	sample_t *in = (sample_t *) jack_port_get_buffer(input_port, nframes);
	sample_t *out = (sample_t *) jack_port_get_buffer(output_port, nframes);
	if (aubio_fvec == NULL || aubio_fvec->data == NULL) {
		init_aubio();
	}
	jack_nframes_t i;
	for (i = 0; i < nframes; i++) {
		if (framecount == hopsize) {
			image_tones_index++;
			if (image_tones_index >= image_tones_size) {
				image_tones_index = 0;
			}
			build_tone(image_tones[image_tones_index], image_tones_amp[image_tones_index], waveform_type);
			float H, S, L, R, G, B;
			Sound_to_HSL(aubio_pitchdetection(aubio, aubio_fvec), max_amp, pitch_scale, lower_bounds, &H, &S, &L);
			HSL_to_RGB(H, S, L, &R, &G, &B);
			write_to_image(dest_image, R, G, B);
			framecount = 0;
			max_amp = 0;
		}
		out[i] = cycle[offset];
		aubio_fvec->data[0][framecount] = (smpl_t) in[i];
		if (fabs(in[i]) > max_amp) {
			max_amp = fabs(in[i]);
		}
		offset++;
		if (offset == samples_per_cycle) {
			offset = 0;
		}
		framecount++;
	}
	return 0;      
}

int srate(jack_nframes_t nframes, void *arg) {
	printf("the sample rate is now %lu/sec\n", nframes);
	sample_rate = nframes;
	return 0;
}

void error(const char *desc) {
	fprintf(stderr, "JACK error: %s\n", desc);
}

void jack_shutdown(void *arg) {
	exit(1);
}

void save_image_file(FILE *image_file, char *file_name, int image_format) {
	image_file = fopen(file_name, "wb");
	if (image_format == 1) {
		gdImageJpeg(dest_image, image_file, -1);
	} else {
		gdImagePng(dest_image, image_file);
	}
	fclose(image_file);
}

void *thread_interface() {
	while(1) {
		int choice = 0;
		printf("0-Quit, 1-Save, 2-Edit, 3-Position\n");
		printf(" > ");
		scanf("%i", &choice);
		if (choice == 0) {
			break;
		} else if (choice == 1) {
			save_image_file(global_image_file, global_file_name, global_image_format);
		} else if (choice == 2) {
			printf("0-Return, 1-Pitch Scale, 2-Lower Bounds, 3-Time-per-pixel (ms), 4-Waveform Type\n");
			printf(" > ");
			scanf("%i", &choice);
			if (choice == 1) {
				printf("Pitch Scale: ");
				scanf("%d", &pitch_scale);
			} else if (choice == 2) {
				printf("Lower Bounds: ");
				scanf("%d", &lower_bounds);
			} else if (choice == 3) {
				printf("Time-per-pixel (ms): ");
				scanf("%f", &ms_time);
				init_aubio();
			} else if (choice == 4) {
				printf("Waveform Type: ");
				scanf("%d", &waveform_type);
			}
		} else {
			printf("Currently at (%i, %i)...\n", X, Y);
		}
	}
}

int main(int argc, char *argv[]) {
	pthread_t thread_interface;//, thread_gtk;

	//GtkWidget *sonify_app;
	//gnome_program_init(PACKAGE, VERSION, LIBGNOMEUI_MODULE, argc, argv, GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR, NULL);
	//sonify_app = create_sonify_app();
	//gtk_widget_show(sonify_app);
	//pthread_create(&thread_gtk, NULL, gtk_main, NULL);
	//gtk_main();

	int image_format;
	int image_format2;
	jack_client_t *client;
	const char **ports;
	char file_name[100], file_name2[100];
	//char * file_name = "un.png";
	//char * file_name2 = "nu.png";
  
	if (argc < 2) {
		fprintf(stderr, "usage: sonify <name>\n");
		return 1;
	}
  
	jack_set_error_function(error);
  
	if ((client = jack_client_new(argv[1])) == 0) {
		fprintf (stderr, "Jack server not running?\n");
		return 1;
	}
  
	jack_set_process_callback(client, process, 0);
	jack_set_sample_rate_callback(client, srate, 0);
	jack_on_shutdown(client, jack_shutdown, 0);
	
	sample_rate = jack_get_sample_rate(client);
	
	input_port = jack_port_register(client, "input", JACK_DEFAULT_AUDIO_TYPE, JackPortIsInput, 0);
	output_port = jack_port_register(client, "output", JACK_DEFAULT_AUDIO_TYPE, JackPortIsOutput, 0);

	printf("Source Image: ");
	scanf("%s", &file_name);
	printf("0-Png, 1-Jpg: ");
	scanf("%d", &image_format);
	printf("Destination Image: ");
	scanf("%s", &file_name2);	
	printf("0-Png, 1-Jpg: ");
	scanf("%d", &image_format2);	
	printf("Pitch Scale: ");
	scanf("%d", &pitch_scale);
	printf("Lower Bounds: ");
	scanf("%d", &lower_bounds);
	printf("Time-per-pixel (ms): ");
	scanf("%f", &ms_time);
	init_aubio();
	printf("Waveform Type: ");
	scanf("%d", &waveform_type);

	printf("1\n");

	FILE *image_file;
	image_file = fopen(file_name, "rb");

	printf("2\n");
	if (image_format == 1) {
		source_image = gdImageCreateFromJpeg(image_file);
	} else {
		source_image = gdImageCreateFromPng(image_file);
	}
	printf("3\n");
	fclose(image_file);
	printf("4\n");
	global_file_name = file_name2;
	printf("5\n");
	global_image_format = image_format2;
	printf("6\n");
	global_image_file = image_file;
	printf("Got here");

	generate_tone_array(source_image);
	gdImageDestroy(source_image);

	dest_image = gdImageCreateTrueColor(gdImageSX(source_image), gdImageSY(source_image));

	build_tone(image_tones[image_tones_index], image_tones_amp[image_tones_index], waveform_type);
	
	if (jack_activate(client)) {
		fprintf(stderr, "cannot activate client\n");
		return 1;
	}

	/*if ((ports = jack_get_ports(client, NULL, NULL, JackPortIsOutput)) == NULL) {
		fprintf(stderr, "no physical capture ports\n");
		exit(1);
	}

	int i = 0;
	while (ports[i] != NULL) {
		if (jack_connect(client, ports[i], jack_port_name(input_port))) {
			fprintf(stderr, "cannot connect input ports\n");
		}
		i++;
	}

	if ((ports = jack_get_ports(client, NULL, NULL, JackPortIsPhysical|JackPortIsInput)) == NULL) {
		fprintf(stderr, "cannot find any physical playback ports\n");
		exit(1);
	}
  
	i = 0;
	while (ports[i] != NULL && i < 2) {
		if (jack_connect(client, jack_port_name(output_port), ports[i])) {
			fprintf(stderr, "cannot connect output ports\n");
		}
		i++;
	}
  
	free(ports);*/

	//pthread_create(&thread_interface, NULL, thread_interface, NULL);

	while(1) {
		save_image_file(global_image_file, global_file_name, global_image_format);
		sleep(1);
	}

	gdImageDestroy(dest_image);
	jack_client_close(client);
	free(cycle);
	free(image_tones);
	free(image_tones_amp);
	del_aubio_pitchdetection(aubio);
	exit(0);
}
